package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.UserCompanyInstitutionAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserCompanyInstitutionListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserCompanyInstitutionReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserCompanyInstitutionResDTO;


/**
 * 行政争议机构接口
 * 
 * @author huaisf
 *
 */
public interface UserCompanyInstitutionApi {

  DubboResult<UserCompanyInstitutionResDTO> getUserCompanyInstitution(
      UserCompanyInstitutionReqDTO userCompanyInstitutionReqDTO);

  DubboResult<PageInfo<UserCompanyInstitutionResDTO>> getUserCompanyInstitutionList(
      UserCompanyInstitutionListReqDTO userCompanyInstitutionListReqDTO);

  DubboResult<CaseUserRegisterResDTO> saveOrUpdateUserCompanyInstitution(
      UserCompanyInstitutionAddReqDTO userCompanyInstitutionAddReqDTO);

  /**
   * 编辑行政机构账号信息
   * @param dto
   */
  void editCompanyInstitutionAccountInfo(UserCompanyInstitutionReqDTO dto);
}
