package com.beiming.odr.user.api.common.enums;

import java.util.HashMap;

/**
 * 环资机构类型枚举
 * @author gaozhiguang
 *
 */
public enum ScavengerOrganizationTypeEnum {
  PUBLIC_SECURITY_BUREAU("公安局"),
  PROCURATORATE("检察院"),
  COURT("法院"),
  ECOLOGICAL_ENVIRONMENT_BUREAU("生态环境局"),
  MEDIATION_ORGANIZATION("调解机构"),
  APPRAISAL_ORGANIZATION("鉴定机构"),
  ASSESSMENT_ORGANIZATION("评估机构");
 
  private String name;


  ScavengerOrganizationTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }
  
  public static ScavengerOrganizationTypeEnum getOrganizationTypeEnum(String name) {
    for (ScavengerOrganizationTypeEnum type : ScavengerOrganizationTypeEnum.values()) {
      if (type.getName().equals(name)) {
        return type;
      }
    }
    return null;
  }
  public static HashMap<String, String> getNameEnumNameMap() {
    HashMap<String, String> map = new HashMap<String, String>();
    for (ScavengerOrganizationTypeEnum type : ScavengerOrganizationTypeEnum.values()) {
      map.put(type.getName(), type.name());
    }
    return map;
  }
  
  public static String[] getNames() {
    ScavengerOrganizationTypeEnum[] values = ScavengerOrganizationTypeEnum.values();
    String orgType[] = new String[values.length];
    for (int i = 0; i < values.length; i++) {
      orgType[i] = values[i].getName();
    }
    return orgType;
  }

}
