package com.beiming.odr.user.api.common.enums;

import com.beiming.framework.domain.DubboResultCode;

/**
 * 错误码规则为四位纯数字 
 * 1.公共模块 
 * 2.登录模块 
 * 3.文件模块 
 * 4.业务模块 
 * 5.后台管理模块
 * 6.公证模块
 * 
 * @author lb
 *
 */
public enum UserDubboErrorCode implements DubboResultCode {
  
  USER_NOT_BINDING_OPEN_ID(2001, "该用户从未绑定微信"),
  USER_PWD_STATUS(4001, "用户弱密码"),
  OPEN_ID_BINDING_OTHER_MOBILE_PHONE(2002, "该微信号已经绑定过其他手机号"),
  NO_FIND_STAFF(2003, "未找到相关工作人员"),
  ;
  
  

  private int value;

  private String desc;

  @Override
  public int value() {
    return value;
  }

  @Override
  public String desc() {
    return desc;
  }

  UserDubboErrorCode(int value, String desc) {
    this.value = value;
    this.desc = desc;
  }

  public int getValue() {
    return value;
  }
}
