package com.beiming.odr.referee.api;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.requestdto.AgentAuthorizeProxyReqDTO;
import com.beiming.odr.referee.dto.requestdto.AuthorizeProxyReqDTO;
import com.beiming.odr.referee.dto.requestdto.BatchFilesReqDTO;
import com.beiming.odr.referee.dto.requestdto.DocAddressReqDTO;
import com.beiming.odr.referee.dto.requestdto.FilesReqDTO;
import com.beiming.odr.referee.dto.responsedto.LawAttachmentResDTO;

/**
 * 文件 附件
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/attachment")
@RestController
public interface AttachmentApi {

  /**
   * 批量保存材料文件
   */
  @RequestMapping(value = "/batchSaveFile", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult batchSaveFile(@RequestBody @Valid BatchFilesReqDTO batchFilesReqDTO);

  /**
   * 批量保存不同类型材料文件
   */
  @RequestMapping(value = "/batchTypeSaveFile", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult batchTypeSaveFile(@RequestBody @Valid List<FilesReqDTO> fileList);

  /**
   * 信访代理人授权委托书上传
   */
  @RequestMapping(value = "/uploadAuthorizeProxy", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> uploadAuthorizeProxy(@RequestBody AuthorizeProxyReqDTO reqDTO);

  /**
   * 获取信访代理人授权委托书
   */
  @RequestMapping(value = "/getAuthorizeProxy", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> getAuthorizeProxy(@RequestParam(name = "caseId") Long caseId,
      @RequestParam(name = "userId") Long userId,
      @RequestParam(name = "personnelId") Long personnelId);

  /**
   * 代理人授权委托书上传
   */
  @RequestMapping(value = "/uploadAgentAuthorizeProxy", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> uploadAgentAuthorizeProxy(@RequestBody AgentAuthorizeProxyReqDTO reqDTO);

  /**
   * 获取代理人授权委托书
   */
  @RequestMapping(value = "/getAgentAuthorizeProxy", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> getAgentAuthorizeProxy(@RequestParam(name = "caseId") Long caseId,
      @RequestParam(name = "personnelId") Long personnelId,
      @RequestParam(name = "agentType") String agentType);

  /**
   * 上传送达确认书 和继续上传生成进度
   * 
   * @param confirmAddressReqDTO
   * @return
   */
  @RequestMapping(value = "/uploadDocAddressAttachment", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> uploadDocAddressAttachment(
      @RequestBody @Valid DocAddressReqDTO docAddressReqDTO);

  /**
   * 通过会议id查询文件信息
   * 
   * @param meetingId
   * @return
   */
  @RequestMapping(value = "/queryLawAttachmentResDTOList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<LawAttachmentResDTO>> queryLawAttachmentResDTOList(
      @RequestParam(name = "meetingId") Long meetingId);

}
