package com.beiming.odr.referee.api;

import javax.validation.Valid;
import com.beiming.odr.referee.constant.RefereeApiConst;
import javax.validation.constraints.NotNull;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.dto.requestdto.CasePersonnelEvidenceReqDTO;
import com.beiming.odr.referee.dto.responsedto.CasePersonnelEvidenceResDTO;

/**
 * 案件存证接口
 * 
 * @author qsh
 * @data 2019年1月4日
 */
@Valid
@RestController
@RequestMapping(RefereeApiConst.URL_PREFIX + "/caseExistingEvidence")
public interface CaseExistingEvidenceApi {

  /**
   * 当事人一键存证,继续存证
   * 
   * @param casePersonnelEvidenceReqDTO
   * @return
   */
  @RequestMapping(value = "/casePersonnelEvidence", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<CasePersonnelEvidenceResDTO> casePersonnelEvidence(
      @RequestBody CasePersonnelEvidenceReqDTO casePersonnelEvidenceReqDTO);

  /**
   * 机构管理员一键存证,继续存证
   * 
   * @param casePersonnelEvidenceReqDTO
   * @return
   */
  @RequestMapping(value = "/caseOrgDossier", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<CasePersonnelEvidenceResDTO> caseOrgDossier(
      @RequestBody CasePersonnelEvidenceReqDTO casePersonnelEvidenceReqDTO);

  /**
   * 案件查询进度信息
   * 
   * @param casePersonnelEvidenceReqDTO
   * @return
   */
  @RequestMapping(value = "/queryProgressCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<CasePersonnelEvidenceResDTO> queryProgressCase(
      @RequestBody CasePersonnelEvidenceReqDTO casePersonnelEvidenceReqDTO);

  /**
   * 卷宗查询进度信息
   * 
   * @param casePersonnelEvidenceReqDTO
   * @return
   */
  @RequestMapping(value = "/queryProgressDossier", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<CasePersonnelEvidenceResDTO> queryProgressDossier(
      @RequestBody CasePersonnelEvidenceReqDTO casePersonnelEvidenceReqDTO);

  /**
   * 获取存证token
   * 
   * @param userId
   * @return
   */
  @RequestMapping(value = "/getToken", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<String> getToken(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "userId") Long userId);
}
