package com.beiming.odr.referee.api;

import com.beiming.odr.referee.dto.requestdto.UpdateDisputeTypeReqDTO;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.requestdto.ApplicationExtensionReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseIdReqDTO;
import com.beiming.odr.referee.dto.responsedto.ExtensionCaseDetailResDTO;

/**
 * 
 * @author qsh
 * @date 2019年9月5日
 *
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/lawCase")
@RestController
public interface LawCaseApi {

  /**
   * 调解员案件申请延期和机构管理员通过或不通过
   * 
   * @author qsh
   * @date 2019年9月5日
   *
   */
  @RequestMapping(value = "/applicationExtension", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> applicationExtension(
      @RequestBody ApplicationExtensionReqDTO applicationExtensionReqDTO);

  /**
   * 延期详情
   * 
   * @author qsh
   * @date 2019年9月6日
   *
   */
  @RequestMapping(value = "/extensionDetail", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ExtensionCaseDetailResDTO> extensionDetail(@RequestBody CaseIdReqDTO caseIdReqDTO);

  /**
   * 更新纠纷类型
   */
  @RequestMapping(value = "/updateDisputeType", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult updateDisputeType(@RequestBody UpdateDisputeTypeReqDTO dto);


}
