package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.GetElementReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveUpdateElementReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseElementListResDTO;
import com.beiming.odr.referee.dto.responsedto.ElementAndContextReqDTO;

/**
 * 要素
 * 
 * @author qsh
 * @date 2019年9月29日
 *
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/lawElement")
@RestController
public interface LawElementApi {

  /**
   * 查询纠纷要素模板
   */
  @RequestMapping(value = "/getElement", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<ElementAndContextReqDTO>> getElement(
      @RequestBody @Valid GetElementReqDTO getElementReqDTO);

  /**
   * 案件要素更新或保存
   * 
   * @author qsh
   * @date 2019年9月29日
   *
   */
  @RequestMapping(value = "/saveAndUpdateElement", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> saveAndUpdateElement(
      @RequestBody @Valid SaveUpdateElementReqDTO saveUpdatElementReqDTO);

  /**
   * 查询案件要素列表
   * 
   * @author qsh
   * @date 2019年9月30日
   *
   */
  @RequestMapping(value = "/queryCaseElementList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<CaseElementListResDTO> queryCaseElementList(
      @RequestBody @Valid CommonIdReqDTO commonIdReqDTO);


}
