package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.MediationCaseDraftDelReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseNumResDTO;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.odr.referee.constant.RefereeApiConst;


/**
 * @Description: 调解案件草稿api接口
 * @Author: chenjt
 * @Date: Created 2018-11-29
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationCaseDraft")
@RestController
public interface MediationCaseDraftApi {
  
  /**
   * 保存草稿案件
   */
  @RequestMapping(value = "/saveMediationCaseDraft", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> saveMediationCaseDraft(
      @RequestBody @Valid MediationCaseReqDTO mediationCaseReqDTO);

  /**
   * 删除草稿案件
   */
  @RequestMapping(value = "/deleteMediationCaseDraft", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult deleteMediationCaseDraft(@RequestBody @Valid MediationCaseDraftDelReqDTO reqDTO);

  /**
   * 查询纠纷登记员创建的案件数量
   */
  @RequestMapping(value = "/queryCaseNumByCreatorId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<CaseNumResDTO> queryCaseNumByCreatorId(
      @RequestParam(name = "creatorId") @Valid Long creatorId);

}
