package com.beiming.odr.referee.api;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.dto.requestdto.LawCaseRelationReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationListOrgsReqDTO;
import com.beiming.odr.referee.dto.requestdto.OperatorReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationListOrgsResDTO;


/**
 * 调解案件信息（同步机构模式）API
 *
 * @author djq
 * @date 2019年4月26日
 *
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationInfoOrgs")
@RestController
public interface MediationInfoOrgsApi {

  /**
   * 获取案件信息（含机构信息）<br>
   * 创建机构及同步机构
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/getMediationInfoOrgs", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationInfoResDTO> getMediationInfoOrgs(@RequestBody MediationInfoReqDTO reqDTO);

  /**
   * 案件列表查询接口（同步机构、已关闭案件）<br>
   * 创建机构及同步机构可见<br>
   * 已关闭案件均可见<br>
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/listMediationInfoOrgs", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<MediationListOrgsResDTO>> listMediationInfoOrgs(
      @RequestBody MediationListOrgsReqDTO reqDTO);

  /**
   * 更新案件同步机构信息<br>
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/editCaseSyncOrgs", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> editCaseSyncOrgs(@RequestBody List<LawCaseRelationReqDTO> reqDTOList);

  /**
   * 结束案件信息<br>
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/endMediationCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> endMediationCase(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL) @RequestParam(
          name = "caseId") Long caseId,
      @RequestBody OperatorReqDTO user);

  /**
   * 重启案件
   * 
   * @param id
   * @param user
   * @return
   */
  @RequestMapping(value = "/restartMediationCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> restartMediationCase(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL) @RequestParam(
          name = "caseId") Long caseId,
      @RequestBody OperatorReqDTO user);

}
