package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomMeetingReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomMeetingUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.CloseMediationRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingRoomListReqDTO;
import com.beiming.odr.referee.dto.responsedto.AddMediationMeetingResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingStayResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingVideoResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;


/**
 * 微解纷视频会议
 * 
 * @author qsh
 * @date 2019年2月20日
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationMeetingRoom")
@RestController
public interface MediationMeetingRoomApi {

  /**
   * 创建视频调解
   */
  @RequestMapping(value = "/addMediationMeeting", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<AddMediationMeetingResDTO> addMediationMeeting(
      @RequestBody AddMediationMeetingRoomReqDTO reqDTO);

  /**
   * 添加调解视频人员
   */
  @RequestMapping(value = "/addMediationMeetingRoomUser", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<AddMediationMeetingResDTO> addMediationMeetingRoomUser(
      @RequestBody AddMediationRoomUserReqDTO reqDTO);

  /**
   * 关闭视频
   */
  @RequestMapping(value = "/closeMediationMeetingRoom", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Integer> closeMediationMeetingRoom(@RequestBody CloseMediationRoomReqDTO reqDTO);

  /**
   * 获取调解视频列表
   */
  @RequestMapping(value = "/getMediationMeetingRoomList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationMeetingRoomUserInfoResDTO>> getMediationMeetingRoomList(
      @RequestBody MediationMeetingRoomListReqDTO mediationMeetingRoomListReqDTO);

  /**
   * 获取调解视频查看详情
   */
  @RequestMapping(value = "/getMediationRoomUserInfoList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationMeetingRoomUserInfoResDTO> getMediationRoomUserInfoList(
      @RequestParam(name = "mediationRoomId") Long mediationRoomId);

  /**
   * 用户视频会议待办列表
   * 
   * @return
   */
  @RequestMapping(value = "/userMeetingStayList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationMeetingStayResDTO>> userMeetingStayList(
      @RequestParam(name = "userId") Long userId);

  /**
   * 创建调解室视频会议
   */
  @RequestMapping(value = "/addMediationRoomMeeting", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<AddMediationMeetingResDTO> addMediationRoomMeeting(
      @RequestBody AddMediationRoomMeetingReqDTO reqDTO);

  /**
   * 添加调解室视频人员
   */
  @RequestMapping(value = "/addMediationRoomMeetingUser", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<AddMediationMeetingResDTO> addMediationRoomMeetingUser(
      @RequestBody AddMediationRoomMeetingUserReqDTO reqDTO);

  /**
   * 视频记录
   * 
   * @param mediationId
   * @return
   */
  @RequestMapping(value = "/getVideoList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MeetingVideoResDTO>> getVideoList(
      @Valid @NotNull(message = "会议id不能为空") @RequestParam(name = "mediationId") Long mediationId);

  /**
   * 网关调调解会议更新开始时间
   * 
   * @param mediationId
   * @return
   */
  @RequestMapping(value = "/updateMediationMeetingStartTime", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> updateMediationMeetingStartTime(
      @Valid @NotNull(message = "房间id不能为空") @RequestParam(name = "roomId") String roomId);

  /**
   * 网关调调解会议更新结束时间
   * 
   * @param mediationId
   * @return
   */
  @RequestMapping(value = "/updateMediationMeetingEndTime", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> updateMediationMeetingEndTime(
      @Valid @NotNull(message = "房间id不能为空") @RequestParam(name = "roomId") String roomId);

  /**
   * 查询调解会议人数
   * 
   * @param mediationRoomId
   * @return
   */
  @RequestMapping(value = "/queryMediationUserList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Integer> queryMediationUserList(@Valid @NotNull(message = "调解室id不能为空") @RequestParam(
      name = "mediationRoomId") Long mediationRoomId);

  /**
   * 判断会议是否关闭
   */
  @RequestMapping(value = "/checkMeetingCloseFlag", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> checkMeetingCloseFlag(@Valid @NotNull(message = "会议id不能为空") @RequestParam(
      name = "mediationRoomId") Long mediationRoomId);

}
