package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.requestdto.SignatureBizInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.SignatureInfoBatchReqDTO;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 签名
 *
 * @author DJQ
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/signatureBatch")
@RestController
public interface SignatureBatchApi {

  /**
   * 批量确认签名
   */
  @RequestMapping(value = "/confirmBatchSignature", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<String> confirmBatchSignature(@RequestBody @Valid SignatureInfoBatchReqDTO reqDTO);


  /**
   * 处理签名业务信息
   */
  @RequestMapping(value = "/processSignatureBizInfoLst", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> processSignatureBizInfoLst(@RequestBody List<SignatureBizInfoReqDTO> reqDTO);

}
