package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.alibaba.fastjson.JSONArray;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.requestdto.SaveSuitReqDTO;
import com.beiming.odr.referee.dto.requestdto.SuitListReqDTO;
import com.beiming.odr.referee.dto.requestdto.SuitPartyDTO;
import com.beiming.odr.referee.dto.requestdto.SuitReqDTO;
import com.beiming.odr.referee.dto.responsedto.SuitAttachmentSimpleResponseDTO;
import com.beiming.odr.referee.dto.responsedto.SuitBaseInfoResponseDTO;
import com.beiming.odr.referee.dto.responsedto.SuitListResDTO;

@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/suit")
@RestController
public interface SuitUserApi {

  /**
   * 根据诉讼id查一条哦记录
   */
  @RequestMapping(value = "/selectOneSuit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<SuitReqDTO> selectOneSuit(@RequestBody SuitReqDTO suitEntity);

  @RequestMapping(value = "/selectSuitUserDTO", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<SuitPartyDTO>> selectSuitUserDTO(
      @RequestParam(name = "suitId") Long suitId,
      @RequestParam(name = "suitUserType") String suitUserType);

  @RequestMapping(value = "/saveSuit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> saveSuit(@RequestBody SaveSuitReqDTO dto);

  @RequestMapping(value = "/lawCause", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<JSONArray> lawCause();
  
  @RequestMapping(value = "/getSuitBaseInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<SuitBaseInfoResponseDTO> getSuitBaseInfo();
  
  @RequestMapping(value = "/getFiles", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<SuitAttachmentSimpleResponseDTO>> getFiles(@RequestParam(name = "suitId") Long suitId);
  
  /**
   * 诉讼列表
   */
  @RequestMapping(value = "/listSuit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<SuitListResDTO>> listSuit(@Valid @RequestBody SuitListReqDTO reqDTO);

}
