package com.beiming.odr.referee.dto;

import java.io.Serializable;
import java.util.List;
import com.beiming.framework.page.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询调解列表的请求参数(Mapper使用)
 * 
 * @author DJQ 2018年7月12日
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MediationListDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  private String roleType; // 用户角色类型： 纠纷登记员 调解人 普通人
  private Long userId; // 用户ID
  private String userType; // 用户类型（申请人，被申请人，调解人）
  private Long orgId; // 服务机构编号

  private String disputeTypeCode; // 纠纷类型
  private String disputeNo; // 纠纷编号
  private String provCode; // 省份code
  private String cityCode; // 城市code
  private String areaCode; // 区code
  private String streetCode; // 街道code
  private String keyWord; // 关键词 编号、姓名、案号
  private String startTime;
  private String endTime;
  private String mediationType; // 调解类型

  private String transfer; // 是否转移
  private String retract; // 包含撤回
  
  private List<String> caseProgress; // 案件状态
  private List<String> caseStatus; // 案件状态
  
  private String caseUserTypes; // 案件用户角色(多状态，逗号分隔)
  
  private Integer status; // 记录状态

  private List<Long> orgIds; // 服务机构列表编号
  private String orgAreaCodeFull; // 区code（完整）
  private String orgAreaCode; // 机构所在地编号
  private Integer orgAreaCodeLevel; // 机构所在地Level
  
  private List<Long> excludeOrgIds; // 区域管理员排序的机构编号
  
  private Boolean distribute; // 是否查询分配列表
  
  private String oderBy; // 排序字段

  /**
   * 创建者类型
   * @see UserRoleEnum
   */
  private String creatorType;
  
  private String caseType;
  

}
