package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 提交到总平台
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CaseSubmitBackReqDTO implements Serializable {

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long caseId;

  //原因
  @NotBlank(message = RefereeValidateMessage.PARAMETER_IS_NULL)
  private String reason;

  //说明
  @NotBlank(message = RefereeValidateMessage.PARAMETER_IS_NULL)
  private String desc;

  //建议处置...
  private String suggest;

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private Long userId;

  @NotBlank(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private String userName;
}
