package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 文书文件请求参数
 * @Author: caiwei
 * @Date: 2019/5/16
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DocFileReqDTO implements Serializable {

  private static final long serialVersionUID = -2941252094732564687L;

  @NotBlank(message = "文件名不能为空")
  private String fileName;

  private Integer fileSize; // 文件大小

  private String fileSuffix; // 文件后缀 ".png/.jpg/.pdf"

  @NotBlank(message = "文件访问路径不能为空")
  private String fileUrl; // 文件访问路径

  private Long userId; // userID

}
