package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * @Description: 录入案件请求参数实体类
 * @Author: caiwei
 * @Date: Created 2018-06-27
 */
@Data
public class MediationCaseReqDTO implements Serializable {

  private static final long serialVersionUID = -6625063532079830540L;

  /**
   * 案件id/草稿案件id
   */
  private Long id;

  /**
   * 是否已在法院立案：0为否，1为是
   */
  private Boolean docket; // add by djq 2018-11-29

  /**
   * 调解类型（人民调解，行政调解）
   */
  private String mediationType;
  
  /**
   * 案件类型
   */
  private String caseType;

  /**
   * 案件录入人id
   */
  private Long creatorId;

  /**
   * 案件录入人的身份
   */
  private String creatorType;

  /**
   * 案件编号
   */
  private String caseNo;

  /**
   * 状态码(05纠纷被拒绝受理等)
   */
  private String lawCaseStatus;

  /**
   * 案件进度
   */
  private String caseProgress;

  /**
   * 咨询纠纷id，咨询转立案存入该值
   */
  private Long disputesId;

  /**
   * 纠纷类型字典表code
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 社区code
   */
  private String communityCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 社区名称
   */
  private String communityName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 机构地区code
   */
  private String orgAreaCode;

  /**
   * 调解员id
   */
  private Long mediatorId;

  /**
   * 调解员名称
   */
  private String mediatorName;

  /**
   * 案件来源。本平台录入； 第三方平台导入。网上立案系统导入，律师平台导入
   */
  private String origin;

  /**
   * 选择性短信发送功能
   *
   * @see com.beiming.odr.referee.enums.SendSMSTypeEnum
   */
  private Integer smsOff;

  /**
   * 申请人诉求
   */
  private String appeal;

  /**
   * 纠纷描述
   */
  private String disputeContent;

  // 案件人
  //@NotNull(message = "案件人不能为空")
  private List<MediationCaseUserReqDTO> personnelList;

  // 创建者
  private String createUser;

  // 更新者
  private String updateUser;

  /**
   * 信访代理人
   */
  private PetitionAgentReqDTO petitionAgentReqDTO;

  /**
   * 纠纷难易程度code
   */
  private String difficultyDisputeCode;

  /**
   * 纠纷难易程度名称
   */
  private String difficultyDisputeName;

  /**
   * 区域层级 省为1 市为2 区为3 街道为4
   */
  private Integer areaLevel;

  /**
   * 来自第三放的ID
   */
  private String orderId;
  
  /**
   * 分平台类型
   */
  private String thirdPlatformType;

  /**
   * 分平台对应诉求的id
   */
  private String thirdPlatformId;

  /**
   * 分平台对应诉求的编号
   */
  private String thirdPlatformNo;

  /**
   * 第三方案件状态
   */
  private String thirdCaseStatus;

  /**
   * 相关附件
   */
  private List<AttachFilesReqDTO> fileList;

  /**
   * 结案时间
   */
  private Date endTime;
}
