package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import lombok.Data;

/**
 * 发送异议书的请求对象
 * 
 * @author DJQ 2018年7月8日
 *
 */
@Data
public class MediationDissentSendReqDTO implements Serializable {

  private static final long serialVersionUID = 2763857461448263390L;

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private Long lawCaseId; // 案件号
  @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId;
  @NotNull(message = RefereeValidateMessage.PARAMETER_MEDIATION_SCHEME_ID_NULL)
  private Long mediationSchemeId; // 调解方案ID
  @NotNull(message = RefereeValidateMessage.PARAMETER_USER_TYPE_NULL)
  private String userType; // 用户类型

  private Long documentId;
  private Long personnelId; // Personnel主键
  private String userName; // 用户名称
  private String caseUserType; // 案件用户类型
  private String sex; // 性别
  private String phone; // 电话号
  private String idCard; // 身份证号
  private String provCode; // 省Code
  private String cityCode; // 市Code
  private String areaCode; // 区Code
  private String streetCode; // 街道Code
  private String provName; // 省Name
  private String cityName; // 市Name
  private String areaName; // 区Name
  private String streetName; // 街Name
  private String address; // 地址
  private String content; // 文本内容

  /**
   * 转换MediationDissentSaveReqDTO
   * 
   * @return
   */
  public MediationDissentSaveReqDTO convertMediationDissentSaveReqDTO() {
    MediationDissentSaveReqDTO reqDTO = new MediationDissentSaveReqDTO(this.lawCaseId, this.userId,
        this.mediationSchemeId, this.userType, this.documentId, this.personnelId, this.userName,
        this.caseUserType, this.sex, this.phone, this.idCard, this.provCode, this.cityCode,
        this.areaCode, this.streetCode, this.provName, this.cityName, this.areaName,
        this.streetName, this.address, this.content);
    return reqDTO;
  }

}
