package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 案件数量统计结果请求
 * 
 * @author CJT 2018年12月11日
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryMediationStatusCountReqDTO implements Serializable {


  private static final long serialVersionUID = 4039225087116009501L;

  private String type; // 类别：机构ORG_MANAGE、调解员MEDIATOR、普通用户COMMON
  private String caseProgress; // 案件进度
  private String orgAreaCode; // 机构所在地编号
  private String orgAreaCodeFull; // 机构所在地编号(全)

  public QueryMediationStatusCountReqDTO(String caseProgress, String orgAreaCode) {
    this.caseProgress = caseProgress;
    this.orgAreaCode = orgAreaCode;
  }
  
  public QueryMediationStatusCountReqDTO(String caseProgress, String orgAreaCode, String orgAreaCodeFull ) {
    this.caseProgress = caseProgress;
    this.orgAreaCode = orgAreaCode;
    this.orgAreaCodeFull = orgAreaCodeFull;
  }
}
