package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.CategoryMiddleTypeEnum;


import com.beiming.odr.referee.enums.FileTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * @author chen
 * @date 2024/08/02
 */
@Data
@ApiModel(description = "上传资料请求参数")
public class ReFileRequestDTO {

  @ApiModelProperty(notes = "附件id", example = "555")
  private Long id;

  @ApiModelProperty(notes = "文件id", example = "555")
  private String fileId;

  @ApiModelProperty(notes = "文件名称", example = "文书.doc")
  private String fileName;

  @ApiModelProperty(notes = "文件类型", example = "EVIDENCE_MATERIAL")
  private FileTypeEnum fileType;

  @ApiModelProperty(notes = "附件中分类，没有中分类为空或传'OTHER'", example = "IDENTITY_CERTIFICATE")
  private CategoryMiddleTypeEnum categoryMiddle;

  @ApiModelProperty(notes = "文件预览url")
  private String previewUrl;

  @ApiModelProperty(notes = "是否数字信访材料, 1:是 0：否")
  private String flag;

}
