package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 重新分配调解员申请类
 * 
 * @author qsh
 * @data 2018年7月4日
 */
@Data
public class ReapportionMediatorApplicationReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  @NotNull(message = "案件id不能为空")
  private Long caseId;
  @NotNull(message = "参数有误")
  private Long cmId;
  @NotNull(message = "用户id不能为空")
  private Long userId;
  private String userName;
  private Long appealId;

  private String remark;
  /**
   * 分配承办人的姓名
   */
  private String transferUserName;

  /**
   * 是否主动分配（0：否 1：是）
   */
  private String flag;
}
