package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.SuitStatusEnum;
import com.beiming.odr.referee.enums.SuitTypeEnums;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class SuitReqDTO implements Serializable {


  /**
   * 诉讼或司法确认
   */
  private SuitTypeEnums type;
  /**
   * 诉讼提交人
   */
  private String userId;

  /**
   * 提交人姓名
   */
  private String userName;
  /**
   * 提交人身份证
   */
  private String idCard;
  /**
   * 提交人手机号
   */
  private String mobilePhone;

  /**
   * 诉讼类型
   */
  private String caseType;

  /**
   * 诉讼类型名称
   */
  private String caseTypeName;

  /**
   * 案由
   */
  private String causeName;

  /**
   * 案由编码
   */
  private String causeCode;

  /**
   * 法院名称
   */
  private String courtName;

  /**
   * 法院编码
   */
  private String courtCode;

  /**
   * 立案申请ID
   */
  private String thirdSuitId;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 诉讼编号
   */
  private String suitNo;

  /**
   * 案件来源
   */
  private String origin;

  /**
   * 案件状态
   */
  private SuitStatusEnum suitStatus;

  /**
   * 第三方的诉讼进度
   */
  private String thirdSuitStatus;

  /**
   * 第三方审核状态
   */
  private String thirdAuditStatus;

  /**
   * 第三方审核结果
   */
  private String thirdAuditResult;

  /**
   * 申请人诉求
   */
  private String appeal;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 纠纷类型code
   */
  private String disputeTypeCode;
  /**
   * 一期数据关联id
   */
  private String oldSuitId;
  /**
   * 当前阶段是否同步成功
   */
  private Boolean stageSyncSuccess;
  /**
   * 当前阶段同步时间
   */
  private Date stageSyncTime;

  /**
   * 标的金额
   */
  private Float targetAmount;

  /**
   * 参考诉费
   */
  private Float suitFee;

  private Long id;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private Integer status;

  /**
   * 备注
   */
  private String remark;

}
