package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import com.beiming.odr.referee.enums.CertificateTypeEnums;
import com.beiming.odr.referee.enums.SexEnums;
import com.beiming.odr.referee.enums.UserTypeEnums;
import lombok.Data;

@Data
public class SuitUserReqDTO implements Serializable {

  private static final long serialVersionUID = -9186174968700097489L;

  /**
   * 用户类型（自然人，法人，非法人组织）
   */

  private UserTypeEnums userType;

  /**
   * 证件类型
   */
  private CertificateTypeEnums certificateType;

  /**
   * 证件号
   */
  private String certificateNo;

  /**
   * 性别
   */
  private SexEnums sex;

  /**
   * 联系电话
   */
  private String contactPhone;

  /**
   * 邮政编码
   */
  private String postcode;

  /**
   * 常住地址
   */
  private String permanentAddress;

  /**
   * 手机号码
   */
  private String mobilePhone;

  /**
   * 用户名字，单位名字
   */
  private String name;

  /**
   * 单位性质
   */
  private String orgType;

  /**
   * 组织机构代码
   */
  private String orgCode;

  /**
   * 注册登记号
   */
  private String orgRegisterNo;

  /**
   * 法定代表人
   */
  private String orgLegalRepresentative;

  /**
   * 文书送达地址
   */
  private String docAddress;


  private SuitAgentUserRequestDTO agent;

  /**
   * 申请人或被申请人ID (司法保存时需要)
   */
  private Long caseUserId;


  /**
   * 诉讼id
   */
  private Long suitId;


  /**
   * 代理了谁
   */
  private Long agentParentUserId;
}
