package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.dto.responsedto.ReAppealHeaderResDTO;
import java.io.Serializable;
import lombok.Data;

/**
 * @Description: 转移工单请求参数
 * @Author: jiangyanfeng
 * @Date: 2019/11/16 0016
 */
@Data
public class TransferRequestDTO implements Serializable {

  private static final long serialVersionUID = 8331541517781508031L;

  /**
   * 工单id
   */
  private Long appealId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 用户id
   */
  private String userName;

  /**
   * 标志是否跳转，默认为true
   */
  private Boolean isTransfer = true;

  /**
   * 指定跳转的部门，可为null
   */
  private Long orgId;

  /**
   * 当前处理部门id
   */
  private Long processOrgId;

  /**
   * 当前处理部门
   */
  private String processOrgName;

  /**
   * 当前处理部门类型
   */
  private String processAppealOrgType;

  /**
   * 工单类型（MEDIATION：调解, LETTERS_VISITS：信访, COMPLAINT：投诉, OTHER：其他)
   */
  private String appealType;

  /**
   * 事件大分类
   */
  private String eventType1;

  /**
   * 事件中分类
   */
  private String eventType2;

  /**
   * 事件小分类
   */
  private String eventType3;

  /**
   * 处理前状态
   */
  private String fromStatus;

  /**
   * 处理后状态
   */
  private String toStatus;

  /**
   * 处理后状态名称
   */
  private String toStatusName;

  /**
   * 操作内容
   */
  private String operateContent;

  /**
   * 处理意见
   */
  private String operateOpinion;

  /**
   * 步骤编码
   */
  private String activityCode;

  /**
   * 步骤名称
   */
  private String activityName;

  /**
   * 附件
   */
  private ReFileRequestDTO file;
  
  /**
   * 是否要清空处置员信息
   */
  private Boolean clearProcessUserFlag;
  
  /**
   * 标志是否办结审核通过，默认为false
   */
  private String isEndAuditPass;
  
  /**
   * 原因类型
   */
  private String reasonType;

  /**
   * 详细原因
   */
  private String detailReason;

  /**
   * 难易程度
   */
  private String difficultyType;

  /**
   * 转入人员id
   */
  private Long toUserId;

  /**
   * 转入人员名称
   */
  private String toUserName;

  private Long processUserId;

  private String processUserName;
  
  public TransferRequestDTO(ReapportionMediatorApplicationReqDTO remediatorApplicationReqDTO, ReAppealHeaderResDTO appeal) {
    this.appealId = remediatorApplicationReqDTO.getAppealId();
    this.userId = remediatorApplicationReqDTO.getUserId();
    this.userName = remediatorApplicationReqDTO.getUserName();
    this.activityCode = "ASSIGN_STAFF";
    this.activityName = "分配工作人员";
    this.isTransfer = false; //不用机构部门流转
    this.toStatus = "HANDING_ON";
    this.toStatusName = "处理中";
    this.operateContent = "分配给" + remediatorApplicationReqDTO.getUserName();
    this.operateOpinion = remediatorApplicationReqDTO.getRemark();
    this.toUserId = remediatorApplicationReqDTO.getCmId();
    this.toUserName = remediatorApplicationReqDTO.getTransferUserName();
    this.processUserId = remediatorApplicationReqDTO.getCmId();
    this.processUserName = remediatorApplicationReqDTO.getTransferUserName();

    this.processOrgId = appeal.getProcessOrgId();
    this.processOrgName = appeal.getProcessOrgName();
    this.processAppealOrgType = appeal.getProcessAppealOrgType();
    this.appealType = appeal.getType();
    // 如果状态为空，保留原状态
    if (this.getToStatus() == null) {
      this.toStatus = appeal.getAppealStatus();
      this.toStatusName = appeal.getAppealStatusName();
    }
  }
  
}