package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 更新当事人类型请求参数实体类
 * @Author: caiwei
 * @Date: 2019/2/27
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UpdateLitigantTypeReqDTO implements Serializable {

  private static final long serialVersionUID = -7453300848174033241L;

  /**
   * 更新当事人id
   */
  private Long personId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 调解室用户类型（申请人、被申请人、当事人）
   */
  private String meetingUserType;

  /**
   * 用户类型（自然人、法人、非法人组织）
   */
  private String userType;

  /**
   * 用户排序
   */
  private Integer userOrder;

  /**
   * 代理人当事人id
   */
  private Long agentPersonId;

  /**
   * 代理人id
   */
  private Long agentId;

  /**
   * 代理人类型
   */
  private String agentType;
}