package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 卷宗返回列表实体类
 * 
 * @author qsh
 * @data 2018年6月29日
 */
@Data
@NoArgsConstructor
public class DossierAttchmentListResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long id;
  private String createUser; // 立卷人
  private String applicantNames; // 申请人姓名
  private String disputeType; // 纠纷类型
  private String caseNo; // 案件编号
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date caseCreateTime; // 登记日期
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date caseCompleteTime; // 结案日期
  private Long auditorId; // 审核人ID
  private String auditorName; // 审核人姓
  private Long lawCaseId; // 案件ID
  private String checkStatus; // 审核状态
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date createTime;

}
