package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 环资会议详情
 * 
 * @author qsh
 * @date 2019年4月25日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MeetingDetailResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * id
   */
  private Long id;
  /**
   * 创建人id
   */
  private Long creatorId;
  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 调解室/视频会议名字
   */
  private String name;

  /**
   * 调解/视频会议状态
   */
  private String mediationStatus;

  /**
   * 会议预订时间
   */
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date orderTime;

  /**
   * 调解室/会议视频房间id
   */
  private String roomId;

  /**
   * 会议类型
   */
  private String meetingType;
  /**
   * 预约类型
   */
  private String orderType;
  
  private Long orgId;
  private String orgName;

  /**
   * 人员信息
   */
  private List<MediationRoomUserInfoResDTO> mediationRoomUserList;
}
