package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import com.beiming.odr.referee.dto.CourtInfoDTO;
import com.beiming.odr.referee.dto.HuayuJudicialMaterialTypeDTO;
import com.beiming.odr.referee.dto.HuayuSimpleDTO;
import lombok.Data;

@Data
public class SuitBaseInfoResponseDTO implements Serializable {

  private static final long serialVersionUID = -4724613591060894603L;

  /**
   * 法院列表(包含案件类型和案由)
   */
  private List<CourtInfoDTO> courtList;

  /**
   * 性别列表
   */
  private List<HuayuSimpleDTO> sexList;

  /**
   * 证件列表
  @ApiModelProperty(notes = "证件类型", example = "[\n"
      + "      {\n"
      + "        \"code\": \"ID_CARD\",\n"
      + "        \"name\": \"身份证\"\n"
      + "      },\n"
      + "      {\n"
      + "        \"code\": \"OFFICER_CARD\",\n"
      + "        \"name\": \"军官证\"\n"
      + "      },\n"
      + "      {\n"
      + "        \"code\": \"PASSPORT\",\n"
      + "        \"name\": \"护照\"\n"
      + "      }\n"
      + "    ]")
  */   
  private List<HuayuSimpleDTO> certificateTypeList;

  /**
   * 诉讼材料分类list
   */
  private List<HuayuSimpleDTO> suitMaterialType;

  /**
   * 代理人类型list
   */
  private List<HuayuSimpleDTO> agentTypeList;

  /**
   * 当事人(身份)类型list
   */
  private List<HuayuSimpleDTO> userTypeList;
  
  /**
   * 单位性质list
   */
  private List<HuayuSimpleDTO> enterprisesNatureList;

  /**
   * 司法确认材料
   */
  private List<HuayuJudicialMaterialTypeDTO> judicialMaterialTypeList;

}
