package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 待确认文书返回实体类
 * @Author: caiwei
 * @Date: 2019/1/25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WaitSignDocumentResDTO implements Serializable {

  private static final long serialVersionUID = -3604445993283930761L;

  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 纠纷类型code
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型姓名
   */
  private String disputeTypeName;

  /**
   * 调解编号
   */
  private String caseNo;

  /**
   * 申请人名称
   */
  private String applicantNames;

  /**
   * 被申请人名称
   */
  private String respondentNames;

  /**
   * 调解机构名称
   */
  private String orgName;

  /**
   * 纠纷描述
   */
  private String disputeContent;

  /**
   * 待确认文书数量
   */
  private Integer waitConfirmDocCount;

  /**
   * 所有待确认文书id
   */
  private String waitConfirmDocIds;

  /**
   * 会议id
   */
  private String meetingIds;

  /**
   * 所有待确认文书类型
   */
  private String waitConfirmDocTypes;

  /**
   * 所有待确认文书code
   */
  private String waitConfirmDocNames;

  /**
   * 可查看文书数量
   */
  private Integer viewDocCount;

  /**
   * 可查看文书id
   */
  private String viewDocIds;

  /**
   * 可查看文书名称
   */
  private String viewDocNames;
}