package com.beiming.odr.referee.enums;

/**
 * 文件类型枚举
 */
public enum FileTypeEnum {

  INDICTMENT("起诉状/上述状"),
  EVIDENCE_MATERIAL("主体材料及证据材料"),
  MATERIALS_UNDER_JURISDICTION("涉及管辖材料"),
  OTHER("其他"),

  /**
   * 文书材料
   */
  JUDICIAL_CONFIRM_APPLY_BOOK("司法确认申请书"),
  MEDIATION_BOOK("调解协议书"),
  MATERIAL_LIST("材料清单"),
  ADDRESS_CONFIRM_BOOK("送达地址确认书"),
  IDENTITY_CERTIFICATE("身份证明"),
  EVIDENCE_INVENTORY("证据清单"),
  DOCUMENT_MATERIAL("文书材料"),

  /**
   * 通知公告材料
   */
  NOTICE("通知公告"),
  ;

  private String desc;

  FileTypeEnum(String desc) {
    this.desc = desc;
  }

  public String getDesc() {
    return desc;
  }
}
