package com.beiming.odr.referee.enums;

import java.util.Arrays;

/**
 * 调解枚举类型
 * 
 * @author qsh
 * @data 2018年7月17日
 */
public enum MeetingTypeEnum {
  
  MEETING_SURVEY("调查"), MEETING_MEDIATE("调解");
  private String name;

  public String getName() {
    return name;
  }

  /**
   * @param name
   */
  MeetingTypeEnum(String name) {
    this.name = name;
  }

  /**
   * 根据name()来搜索
   */
  public static MeetingTypeEnum getByName(String enumName) {
    return Arrays.stream(MeetingTypeEnum.values())
        .filter(switchEnum -> switchEnum.name().equals(enumName))
        .findFirst()
        .orElse(null);
  }
}
