package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.dto.requestdto.MeetingNewSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveTempMediatorReqDTO;
import com.beiming.odr.referee.dto.requestdto.WaitMeetingReqDTO;
import com.beiming.odr.referee.dto.responsedto.WaitCaseMeetingListResDTO;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 新会议接口
 * 
 * @author qsh
 * @data 2018年10月22日
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/caseMeetingNew")
@RestController
public interface CaseMeetingNewApi {
  /**
   * 保存新会议
   *
   * @param meetingNewSaveReqDTO
   * @return
   */
  @RequestMapping(value = "/caseNewMeetingSave", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult caseNewMeetingSave(@RequestBody @Valid MeetingNewSaveReqDTO meetingNewSaveReqDTO);

  /**
   * 网关调更新会议结束时间
   * 
   * @param roomId
   * @return
   */
  @RequestMapping(value = "/updateCaseMeeting", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult updateCaseMeeting(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_MEET_ID_NULL) @RequestParam(
          name = "roomId") String roomId);

  /**
   * 网关调更 开始时间更新
   *
   * @param roomId
   * @return
   */
  @RequestMapping(value = "/updateMeetingStartTime", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> updateMeetingStartTime(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_MEET_ID_NULL) @RequestParam(
          name = "roomId") String roomId);

  /**
   * 保存临时调解员
   *
   * @param req
   * @return
   */
  @RequestMapping(value = "/saveTempMediator", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult saveTempMediator(@RequestBody @Valid SaveTempMediatorReqDTO req);

  /**
   * 待参与视频列表
   *
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/waitCaseMeetingList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<WaitCaseMeetingListResDTO>> waitCaseMeetingList(
      @RequestBody WaitMeetingReqDTO reqDTO);
}
