package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.referee.dto.requestdto.DelFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossGeneraterReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierAuditFailReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierListReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierRemarkReqDTO;
import com.beiming.odr.referee.dto.responsedto.DisplayDossierResDTO;
import com.beiming.odr.referee.dto.responsedto.DossAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierAttchmentListResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierVolumeResDTO;
import com.beiming.odr.referee.dto.responsedto.LawAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.LawProgressResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;

/**
 * 卷宗api
 * 
 * @author qsh
 * @data 2018年6月28日
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/lawCaseDossier")
@RestController
public interface LawCaseDossierApi {

  /**
   * 通过案件id查询案件对应文件
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/getLawAttachment", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<LawAttachmentResDTO>> getLawAttachment(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "caseId") Long caseId,
      @RequestParam(name = "objectType") String objectType);

  /**
   * 通过案件id查询生成卷宗
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/getGenerateFile", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult getGenerateFile(@RequestBody @Valid DossGeneraterReqDTO dossGeneraterReqDTO);

  /**
   * 卷宗列表
   * 
   * @return
   */
  @RequestMapping(value = "/getDossierList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<DossierAttchmentListResDTO>> getDossierList(
      @RequestBody @Valid DossierListReqDTO dossierListReqDTO);

  /**
   * 进度详情
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/queryDossierList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<LawProgressResDTO>> queryDossierList(
      @RequestParam(name = "caseId") Long caseId,
      @RequestParam(name = "subjectType") String subjectType);

  /**
   * 卷宗审核失败
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/dossierBack", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult dossierBack(@RequestBody DossierAuditFailReqDTO dossierAuditFailReqDTO);

  /**
   * 撤销卷宗信息
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/backOutDossier", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult backOutDossier(@RequestParam(name = "dossierId") Long dossierId);

  /**
   * 提交卷宗审核 agreementNumber 协议编号 remark 备注
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/submitLawCaseDossier", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult submitLawCaseDossier(@RequestParam(name = "dossierId") Long dossierId,
      @RequestParam(name = "agreementNumber") String agreementNumber,
      @RequestParam(name = "remark") String remark);

  /**
   * 卷宗审核通过
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/auditLawCaseDossierPass", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult auditLawCaseDossierPass(@RequestParam(name = "caseId") Long caseId,
      @RequestParam(name = "userId") Long userId, @RequestParam(name = "userName") String userName);

  /**
   * 电子卷宗上传文件
   * 
   * @return
   */
  @RequestMapping(value = "/saveDossierFile", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult saveDossierFile(@RequestBody DossierFileReqDTO dossierFileReqDTO);

  /**
   * 卷宗数据回显
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/displayFileDossier", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<DisplayDossierResDTO> displayFileDossier(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "caseId") Long caseId);

  /**
   * 删除文件
   * 
   * @param fileId
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/delDossierFile", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult delDossierFile(@RequestBody DelFileReqDTO delFileReqDTO);

  /**
   * 查询文件信息
   * 
   * @param caseId
   * @param categoryBig
   * @param categoryMiddle
   * @return
   */
  @RequestMapping(value = "/attachmentList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<DossAttachmentResDTO>> attachmentList(
      @RequestBody AttachmentListReqDTO attachmentListReqDTO);

  /**
   * 修改卷宗备注信息
   * 
   * @return
   */
  @RequestMapping(value = "/modifyDossierName", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult modifyDossierName(@RequestBody DossierRemarkReqDTO dossierRemarkReqDTO);

  /**
   * 查询卷宗信息
   * 
   * @return
   */
  @RequestMapping(value = "/queryDossier", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<DossierVolumeResDTO> queryDossier(@RequestParam(name = "dossierId") Long dossierId);

  /**
   * @date 2018-09-28 查询卷宗文件附件用于卷内目录
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/queryAttachmentListDossier", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<DossAttachmentResDTO>> queryAttachmentListDossier(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "caseId") Long caseId);

}
