package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.requestdto.BatchDistributionCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.BatchDistributionReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseImportListIdsReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseImportExistReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseImportReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseImportSaveReqDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseImportExistResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseImportListResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.odr.referee.constant.RefereeApiConst;

/**
 * 案件导入api
 * 
 * @author qsh
 *
 * @2019年3月1日
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/lawCaseImport")
@RestController
public interface LawCaseImportApi {

  /**
   * 案件导入列表
   * 
   * @param lawCaseImportReqDTO
   * @return
   */
  @RequestMapping(value = "/queryCaseImportList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<LawCaseImportListResDTO>> queryCaseImportList(
      @RequestBody LawCaseImportReqDTO lawCaseImportReqDTO);

  /**
   * 是否需要发送短信
   * 
   * @param caseImportListIdsReqDTO
   * @return
   */
  @RequestMapping(value = "/sendSmsCaseImport", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> sendSmsCaseImport(
      @RequestBody @Valid CaseImportListIdsReqDTO caseImportListIdsReqDTO);

  /**
   * 批量分配机构
   * 
   * @param batchDistributionOrgReqDTO
   * @return
   */
  @RequestMapping(value = "/batchDistributionOrg", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> batchDistributionOrg(
      @RequestBody @Valid BatchDistributionReqDTO batchDistributionOrgReqDTO);

  /**
   * 批量调解成功
   * 
   * @param batchDistributionCaseReqDTO
   * @return
   */
  @RequestMapping(value = "/batchCaseSuccess", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> batchCaseSuccess(
      @RequestBody @Valid BatchDistributionCaseReqDTO batchDistributionCaseReqDTO);

  /**
   * 批量调解失败
   * 
   * @param atchDistributionCaseReqDTO
   * @return
   */
  @RequestMapping(value = "/batchCaseFail", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> batchCaseFail(
      @RequestBody @Valid BatchDistributionCaseReqDTO atchDistributionCaseReqDTO);

  /**
   * 保存导入案件相关信息
   * 
   * @return
   */
  @RequestMapping(value = "/saveImportCaseData", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult saveImportCaseData(@RequestBody LawCaseImportSaveReqDTO reqDTO);

  /**
   * 批量保存导入案件相关信息
   * 
   * @return
   */
  @RequestMapping(value = "/saveImportCaseDataList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult saveImportCaseDataList(@RequestBody List<LawCaseImportSaveReqDTO> reqDTOList);

  /**
   * 根据文件名查询已导入案件
   * 
   * @return
   */
  @RequestMapping(value = "/queryExistImportData", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<LawCaseImportExistResDTO>> queryExistImportData(
      @RequestBody LawCaseImportExistReqDTO reqDTO);

}
