package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.MediationCaseBaseDTO;
import com.beiming.odr.referee.dto.OperateCaseDTO;
import com.beiming.odr.referee.dto.requestdto.CancelCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseDealCardsReqDTO;
import com.beiming.odr.referee.dto.requestdto.DeleteCasePersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.EditCaseDisputeReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationImportCaseReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationImportCaseResDTO;
import com.beiming.odr.referee.dto.responsedto.SaveCaseUserResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description: 调解案件api接口
 * @Author: caiwei
 * @Date: Created 2018-06-20
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationCase")
@RestController
public interface MediationCaseApi {

  /**
   * 根据案件id查询案件信息
   */
  @RequestMapping(value = "/getMediationCaseInfoById", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<CaseResDTO> getMediationCaseInfoById(@RequestParam(name = "caseId") Long caseId);

  /**
   * 插入案件
   */
  @RequestMapping(value = "/insertMediationCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> insertMediationCase(
      @RequestBody @Valid MediationCaseReqDTO mediationCaseReqDTO);

  /**
   * 插入案件(湖州环资)
   */
  @RequestMapping(value = "/insertMediationCaseHz", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> insertMediationCaseHz(
      @RequestBody @Valid MediationCaseReqDTO mediationCaseReqDTO);

  /**
   * 批量导入案件
   */
  @RequestMapping(value = "/insertMediationImportCaseList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationImportCaseResDTO>> insertMediationImportCaseList(
      @RequestBody List<MediationImportCaseReqDTO> reqDTOList);

  /**
   * 编辑案件纠纷信息
   */
  @RequestMapping(value = "/editCaseDisputeInfo", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult editCaseDisputeInfo(@RequestBody EditCaseDisputeReqDTO dto);

  /**
   * 新增或者修改案件人
   */
  @RequestMapping(value = "/saveOrEditCaseUser", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<SaveCaseUserResDTO> saveOrEditCaseUser(
      @RequestBody @Valid MediationCaseUserReqDTO mediationCaseUserReqDTO);

  /**
   * 删除案件人
   */
  @RequestMapping(value = "/deleteCasePersonnel", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult deleteCasePersonnel(@RequestBody @Valid DeleteCasePersonnelReqDTO reqDTO);

  /**
   * 撤回调解
   */
  @RequestMapping(value = "/cancelLawCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Integer> cancelLawCase(@RequestBody CancelCaseReqDTO reqDTO);

  /**
   * 获取调解案件材料
   */
  @RequestMapping(value = "/getCaseMaterial", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult getCaseMaterial(@RequestParam(name = "caseId") @Valid Long caseId);

  /**
   * 根据案件id查询案件基本信息
   */
  @RequestMapping(value = "/getMediation", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationCaseBaseDTO> getMediation(@RequestParam(name = "caseId") Long caseId);

  /**
   * 删除案件
   */
  @RequestMapping(value = "/deleteCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult deleteCase(@RequestBody @Valid OperateCaseDTO dto);

  /**
   * 作废案件
   */
  @RequestMapping(value = "/trashCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult trashCase(@RequestBody @Valid OperateCaseDTO dto);
  
  /**
   * 更新案件红黄牌状态
   */
  @RequestMapping(value = "/updateCaseDealCards", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult updateCaseDealCards(@RequestBody @Valid CaseDealCardsReqDTO reqDTO);
  
  /**
   * 同步修改或新增信访用户
   */
  @RequestMapping(value = "/syncSaveMediationCasePerson", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult syncSaveMediationCasePerson(@RequestBody @Valid MediationCaseUserReqDTO reqDTO, 
      @RequestParam(name = "originUserId", required = false) Long originUserId);
  
  /**
   * 同步删除案件人
   */
  @RequestMapping(value = "/syncDeleteCasePerson", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult syncDeleteCasePerson(@RequestBody DeleteCasePersonnelReqDTO reqDTO);

  @RequestMapping(value = "/insertSzxfCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> insertSzxfCase(@RequestBody MediationCaseReqDTO reqDTO);
}
