package com.beiming.odr.referee.api;

import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.MediationPromiseGetReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationPromiseGetResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;

/**
 * 承诺书API
 * 
 * @author DJQ 2018年6月26日
 *
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationDocPromise")
@RestController
public interface MediationDocPromiseApi {

  /**
   * 获取承诺书
   * 
   * @return
   */
  @RequestMapping(value = "/getMediationPromise", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationPromiseGetResDTO> getMediationPromise(
      @RequestBody @Valid MediationPromiseGetReqDTO reqDTO);

}
