package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.beiming.odr.referee.dto.requestdto.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCasePersonResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;


/**
 * 调解
 *
 * @author qsh
 * @data 2018年7月3日
 */
@SuppressWarnings("rawtypes")
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationMeeting")
@RestController
public interface MediationMeetingApi {

  /**
   * 调解成功
   *
   * @return
   */
  @RequestMapping(value = "/mediationSuccess", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult mediationSuccess(
      @RequestBody @Valid MediationSuccessFailReqDTO mediationSuccessFailReqDTO);

  /**
   * 调解失败
   *
   * @return
   */
  @RequestMapping(value = "/mediationFail", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult mediationFail(
      @RequestBody @Valid MediationSuccessFailReqDTO mediationSuccessFailReqDTO);

  /**
   * 审核结案
   */
  @RequestMapping(value = "/auditEndCase", method = RequestMethod.POST,
          produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult auditEndCase(@RequestBody @Valid AuditEndCaseReqDTO reqDTO);
  
  /**
   * 其他情形结案
   */
  @RequestMapping(value = "/mediationEndOther", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult mediationEndOther(@RequestBody @Valid MediationSuccessFailReqDTO mediationSuccessFailReqDTO);

  /**
   * 申请重新分配
   */
  @RequestMapping(value = "/applyReallocate", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult applyReallocate(@RequestBody @Valid ApplyReallocateReqDTO reqDTO);

  /**
   * 重新分配
   *
   * @return
   */
  @RequestMapping(value = "/reallocate", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult reallocate(@RequestBody @Valid MediationReallocateReqDTO diationReallocateReqDTO);

  /**
   * 受理
   *
   * @return
   */
  @RequestMapping(value = "/accept", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult accept(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL) @RequestParam(
          name = "caseId") Long caseId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "userId") Long userId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "userName") String userName);

  /**
   * 不受理
   *
   * @return
   */
  @RequestMapping(value = "/caseDeclined", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult caseDeclined(@RequestBody @Valid CaseDeclinedReqDTO caseDeclinedReqDTO);

  /**
   * 分配调解员申请
   *
   * @return
   */
  @RequestMapping(value = "/reMediatorApplication", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult reMediatorApplication(
      @RequestBody @Valid ReapportionMediatorApplicationReqDTO requestDTO);

  /**
   * 转移调解机构
   *
   * @param transferMediationReqDTO
   * @return
   */
  @RequestMapping(value = "/transferMediation", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult transferMediation(
      @RequestBody @Valid TransferMediationReqDTO transferMediationReqDTO);

  /**
   * 查询案件与人员关系
   *
   * @param caseId
   * @param userId
   * @return
   */
  @RequestMapping(value = "/personList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<LawCasePersonResDTO>> personList(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "caseId") Long caseId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "userId") Long userId);

  /**
   * 申请诉讼，更新案件状态
   *
   * @param caseId 案件id
   * @param updateUserName 更新人名字
   */
  @RequestMapping(value = "/goSuit", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult goSuit(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL) @RequestParam(
          name = "caseId") Long caseId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "updateUserName") String updateUserName);

  /**
   * 申请司法确认，更新案件状态
   *
   * @param caseId 案件id
   * @param updateUserName 更新人名字
   */
  @RequestMapping(value = "/goJudicialConfirm", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult goJudicialConfirm(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL) @RequestParam(
          name = "caseId") Long caseId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "updateUserName") String updateUserName);

  /**
   * 小程序会议提醒单条会议
   * 
   * @param userId
   * @return
   */
  @RequestMapping(value = "/queryMeetingTime", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<CaseMeetingPersonnelResDTO> queryMeetingTime(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL) @RequestParam(
          name = "userId") Long userId,
      @Valid @NotNull(message = RefereeValidateMessage.MEETING_STATUS_NULL) @RequestParam(
          name = "meetingStatus") String meetingStatus,
      @RequestParam(name = "minute") int minute);

  /**
   * 小程序会议提醒多条
   * 
   * @param userId
   * @return
   */
  @RequestMapping(value = "/queryMeetingTimeList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> queryMeetingTimeList(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL) @RequestParam(
          name = "userId") Long userId,
      @Valid @NotNull(message = RefereeValidateMessage.MEETING_STATUS_NULL) @RequestParam(
          name = "meetingStatus") String meetingStatus,
      int minute);

  /**
   * 查询url路径
   * 
   * @param meetingId
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/queryMeetingPersonnel", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> queryMeetingPersonnel(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_MEET_ID_NULL) @RequestParam(
          name = "meetingId") Long meetingId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL) @RequestParam(
          name = "userId") Long userId,
      @Valid @NotNull(message = RefereeValidateMessage.MEETING_STATUS_NULL) @RequestParam(
          name = "meetingStatus") String meetingStatus);


  @RequestMapping(value = "/personListAgent", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<LawCasePersonResDTO>> personListAgent(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "caseId") Long caseId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "userId") Long userId);

}
