package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.CloseMediationRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdateMediationRoomPersonReqDTO;
import com.beiming.odr.referee.dto.responsedto.AddMediationRoomResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomPersonResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import java.util.ArrayList;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.odr.referee.constant.RefereeApiConst;


/**
 * @Description: 调解室api
 * @Author: caiwei
 * @Date: 2019/1/16
 */
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationRoom")
@RestController
public interface MediationRoomApi {

  /**
   * 创建调解室
   */
  @RequestMapping(value = "/addMediationRoom", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<AddMediationRoomResDTO> addMediationRoom(@RequestBody AddMediationRoomReqDTO reqDTO);

  /**
   * 添加调解室用户
   */
  @RequestMapping(value = "/addMediationRoomUser", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<String> addMediationRoomUser(@RequestBody AddMediationRoomUserReqDTO reqDTO);

  /**
   * 关闭调解室
   */
  @RequestMapping(value = "/closeMediationRoom", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Integer> closeMediationRoom(@RequestBody CloseMediationRoomReqDTO reqDTO);

  /**
   * 获取调解室用户信息列表
   */
  @RequestMapping(value = "/getMediationRoomUserInfoList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationRoomUserInfoResDTO>> getMediationRoomUserInfoList(
      @RequestParam(name = "mediationRoomId") Long mediationRoomId);

  /**
   * 查询调解室的实名认证标识
   */
  @RequestMapping(value = "/getAuthFlagByMediationRoomId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> getAuthFlagByMediationRoomId(
      @RequestParam(name = "mediationRoomId") Long mediationRoomId);

  /**
   * 校验当前登录人员是否为调解员
   */
  @RequestMapping(value = "/checkIsMediator", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> checkIsMediator(@RequestParam(name = "mediationRoomId") Long mediationRoomId,
      @RequestParam(name = "userId") Long userId);

  /**
   * 获取调解室人员
   */
  @RequestMapping(value = "/getMediationRoomPerson", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationRoomPersonResDTO>> getMediationRoomPerson(
      @RequestParam(name = "mediationRoomId") Long mediationRoomId);

  /**
   * 获取调解室调解员
   */
  @RequestMapping(value = "/getMediationRoomMediator", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationRoomPersonResDTO> getMediationRoomMediator(
      @RequestParam(name = "mediationRoomId") Long mediationRoomId);

  /**
   * 更新调解室人员类型
   */
  @RequestMapping(value = "/updateMediationRoomPersonType", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult updateMediationRoomPersonType(@RequestBody UpdateMediationRoomPersonReqDTO reqDTO);
  
}
