package com.beiming.odr.referee.dto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 信访代理人案例详情返回
 * @Author: chenjt
 * @Date: Created 2018-10-24
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PetitionAgentDTO implements Serializable {


  private static final long serialVersionUID = 9073193676210757606L;

  /**
   * 信访代理人主键 id
   */
  private Long id;

  /**
   * 信访代理人id
   */
  private Long userId;

  /**
   * 信访代理人姓名
   */
  private String userName;

  /**
   * 信访代理人性别
   */
  private String sex;

  /**
   * 信访代理人联系电话
   */
  private String phone;

  /**
   * 信访代理人身份证号
   */
  private String idCard;

  /**
   * 信访代理人委托书主键id
   */
  private String proxyId;

  /**
   * 信访代理人委托书id
   */
  private String proxyFileId;

  /**
   * 信访代理人委托书名称
   */
  private String proxyFileName;

  public PetitionAgentDTO(MediationCasePersonnelDTO dto) {
    this.id = dto.getId();
    this.userId = dto.getUserId();
    this.userName = dto.getName();
    this.sex = dto.getSex();
    this.phone = dto.getPhone();
    this.idCard = dto.getIdCard();
    this.proxyId = dto.getProxyId();
    this.proxyFileId = dto.getProxyFileId();
    this.proxyFileName = dto.getProxyFileName();

  }

}
