package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * 创建会议
 * 
 * @author qsh
 * @date 2019年4月25日
 */
@Data
public class AddScavengerMeetingReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * 当事人信息列表
   */
  private List<MediationMeetingUseReqDTO> litigantList;

  /**
   * 调解员
   */
  private MediationMeetingUseReqDTO mediator;


  /**
   * 调解室/视频会议名字
   */
  private String name;

  /**
   * 父级id
   */
  private Long parentId;

  /**
   * 调解/视频会议状态
   */
  private String mediationStatus;

  /**
   * 会议预订时间
   */
  private Date orderTime;

  /**
   * 是否电话外呼
   */
  private Integer callFlag;

  /**
   * 是否需要身份验证
   */
  private Integer authFlag;

  /**
   * 会议类型
   */
  private String meetingType;
  /**
   * 预约类型
   */
  private String orderType;
  /**
   * 机构id
   */
  private Long orgId;
  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 案件id
   */
  private Long caseId;
  /**
   * 创建者id
   */
  private Long creatorId;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;
  /**
   * 附件信息
   */
  private List<AttachFilesReqDTO> attachFilesList;
}
