package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import lombok.Data;

/**
 * 批量分配调解成功失败
 * 
 * @author qsh
 *
 * @2019年3月4日
 */
@Data
public class BatchDistributionCaseReqDTO implements Serializable {
  private static final long serialVersionUID = 1L;

  /**
   * 案件id
   */
  @Valid
  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Size(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL, min = 1)
  private List<Long> caseIds;

  private Long userId;

  private String userName;
}
