package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Data;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.dto.responsedto.BatchCaseIdAndOrdIdReqDTO;

/**
 * 批量分配机构
 * 
 * @author qsh
 *
 * @2019年3月1日
 */
@Data
public class BatchDistributionReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * 案件id 机构id
   */
  @Valid
  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Size(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL, min = 1)
  private List<BatchCaseIdAndOrdIdReqDTO> caseIdAndOrgId;

  private Long userId;

  private String userName;
}
