package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Data;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.enums.SendSMSTypeEnum;

/**
 * 是否发送短信案件id list
 * 
 * @author qsh
 *
 * @2019年3月4日
 */
@Data
public class CaseImportListIdsReqDTO implements Serializable {
  private static final long serialVersionUID = 1L;


  @Valid
  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Size(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL, min = 1)
  private List<Long> caseIds;

  /**
   * 选择性短信发送功能
   * 
   * @see SendSMSTypeEnum
   */
  @NotNull(message = RefereeValidateMessage.SEND_SMS_OFF_NULL)
  private Integer smsOff;

}
