package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by chenjt on 2019/9/9
 *
 * 案件机构 提交 X级管理员
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CaseOrgToAreaReqDTO implements Serializable {

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long caseId;

  private Long orgId;

  private String orgName;

  //转移原因
  private String reason;

  //记录到转移表   提交 X级管理员  fromAreaCode 和 toAreaCode 一样
  private String fromAreaCode;

  ///转移后地区
  //@NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL)
  //private String toAreaName;

  //转移后地区的code   记录到转移表
  //@NotBlank(message = RefereeValidateMessage.PARAMETER_IS_NULL)
  private String toAreaCode;

  @NotNull(message = "用户id不能为空")
  private Long userId;
  @NotBlank(message = "用户名不能为空")
  private String userName;

}
