package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author chenjt
 * @data 2019年9月8日
 */
@Data
@NoArgsConstructor
public class CaseReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  @NotNull(message = "id不能为空")
  @Min(value = 1, message = "值非法")
  private Long id;


  private Integer status;

  public CaseReqDTO(Long id) {
    this.id = id;
  }

  public CaseReqDTO(Long id, Integer status) {
    this.id = id;
    this.status = status;
  }
}
