package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 拒绝承诺书的请求对象
 * 
 * @author DJQ 2018年7月8日
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationPromiseRefuseReqDTO implements Serializable {

  private static final long serialVersionUID = 2763857461448263390L;

  private Long lawCaseId;
  @NotNull(message = RefereeValidateMessage.PARAMETER_DOCUMENT_ID_NULL)
  private Long documentId;
  @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId;

}
