package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import lombok.Data;

/**
 * 发送调解笔录的请求对象
 * 
 * @author DJQ 2018年6月26日
 *
 */
@Data
public class MediationRecordSendReqDTO implements Serializable {

  private static final long serialVersionUID = 4014915557247117808L;

  private Long documentId; // ID
  @NotNull(message = RefereeValidateMessage.PARAMETER_MEET_ID_NULL)
  private Long meetingId;
  private Long lawCaseId;
  private String caseNo; // 案件号
  private String disputeType; // 纠纷类型
  private String content; // 笔录内容
  private String location; // 地点
  private String time; // 时间
  @NotNull(message = RefereeValidateMessage.PARAMETER_RECORD_REMARK_NULL)
  private String remark; // 备注
  private List<MediationPersonalReqDTO> mediationParticipants; // 会议参与人信息（调解员）


  public MediationRecordSaveReqDTO convertMediationRecordSaveReqDTO() {
    MediationRecordSaveReqDTO res = new MediationRecordSaveReqDTO();
    res.setDocumentId(this.documentId); // ID
    res.setMeetingId(this.meetingId);
    res.setLawCaseId(this.lawCaseId);
    res.setCaseNo(this.caseNo); // 案件号
    res.setDisputeType(this.disputeType); // 纠纷类型
    res.setContent(this.content); // 笔录内容
    res.setLocation(this.location); // 地点
    res.setTime(this.time); // 时间
    res.setRemark(this.remark); // 备注
    res.setMediationParticipants(this.mediationParticipants); // 会议参与人信息（调解员）
    return res;
  }

}
