package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 工单延期结果通知
 * 
 * @author qsh
 * @date 2019年9月9日
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OtterNoticeReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 案件id-odr入参
   */
  private Long caseId;
  /**
   * 表单号，必填
   */
  private String serialnum;
  /**
   * 申请状态(通过或不通过)，必填
   */
  private String status;
  /**
   * 审核意见，选填
   */
  private String suggestion;
  /**
   * 延期时限，必填
   */
  private Integer delay;
  /**
   * 延期时间单位，必填
   */
  private String delayUnit;
  /**
   * 应完成时间(延期审批后)，选填
   */
  private Date finishtime;
}
