package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by chenjt 2019-09-10
 *
 * 更新进度
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ReAppealProcessUpdateReqDTO implements Serializable {

  private static final long serialVersionUID = 6056042729850330362L;

  @NotNull(message = "诉求id不能为空")
  @Min(value = 1, message = "值非法")
  private Long appealId;

  /**
   * 承办单位ID
   */
  private Long processOrgId;

  /**
   * 承办单位类型
   */
  private String processAppealOrgType;

  /**
   * 承办单位名字
   */
  private String processOrgName;

  /**
   * 承办单位区域code
   */
  private String processOrgAreaCode;

  /**
   * 承办单位等级
   */
  private Integer processOrgLevel;

  /**
   * 承办人ID
   */
  private Long processUserId;

  /**
   * 承办人名字
   */
  private String processUserName;

  /**
   * 流程记录
   */
  private ReAppealFlowSaveReqDTO flowSaveReqDTO;

  /**
   * 更改状态参数
   */
  ReAppealStatusUpdateReqDTO statusUpdateReqDTO;
  
  /**
   * 是否要清空处置员信息
   */
  private Boolean clearProcessUserFlag = false;

  /**
   * 纠纷难易程度
   */
  private String difficultyType;

  /**
   * 市入驻单位下派标识(0:否 1:是)
   */
  private String cityUnitDownFlag;
}
