package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.util.StringUtils;
import com.beiming.odr.referee.enums.EnterprisesNatureEnums;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * Created by zli on 2018/7/10. 人员信息
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SuitPartyDTO extends SuitAgentDTO implements Serializable {


  private static final long serialVersionUID = -8574632347989580817L;

  private String suitUserType;

  private String userType;

  private String name;


  private String sex;


  private String certificateType;

  private String certificateNo;

  private String mobilePhone;

  private String contactPhone;

  private String permanentAddress;


  private String orgType;


  private String orgTypeName;

  private String orgCode;

  private String orgRegisterNo;

  private String orgLegalRepresentative;

  private String docAddress;
  
  private String postcode;

  public String getOrgTypeName() {
    return StringUtils.isBlank(this.orgType) ? null
        : EnterprisesNatureEnums.valueOf(this.orgType).getName();
  }
}
