package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 第三方当事人信息
 * 
 * @author qsh
 *
 * @2019年6月13日
 */
@Data
public class ThirdPartysReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 当事人ID
   */
  @NotNull(message = "当事人ID不能为空")
  private String id;
  /**
   * 姓名
   */
  @NotNull(message = "姓名不能为空")
  private String name;
  /**
   * 手机号
   */
  @NotNull(message = "手机号不能为空")
  private Long telephone;
  /**
   * 当事人类型
   */
  @NotNull(message = "当事人类型不能为空")
  private String partyType;
  /**
   * 诉讼地位
   */
  @NotNull(message = "诉讼地位不能为空")
  private String status;
  /**
   * 性别
   */
  private String sex;
  /**
   * 出生年月
   */
  private String birthday;
  /**
   * 民族
   */
  private String nation;
  /**
   * 身份证号码
   */
  @NotNull(message = "身份证号码不能为空")
  private String idcardNo;
  /**
   * 地址
   */
  @NotNull(message = "地址不能为空")
  private String address;
  /**
   * 法定代表人
   */
  private String legalRepresent;
}
